/***********************************************************
File:         BMC23M0x1_RX_4CH_StepperMotor.ino
Description:  Use with BMC21M0x1_TX.ino.
              By pressing the button, the motor rotation and LED lights can be controlled:
              KEY1:motor run
              KEY2:motor stop
              KEY3:LED toggle
              KEY4:LED 
***********************************************************/
#include <MsTimer.h>
#include "BM2302-9x-1.h"
#include <BMP73T104.h>

BM2302_9x_1     BMC23(22,&Serial1); //BMC23M0x1,use BMCOM1
BMP73T104 myStepper1(2,StepMotor);
uint8_t receiveData = 0;
uint8_t receiveData_Temp = 0;

int LED = 13;  
volatile uint8_t ledFlag = 0;   //0:OFF  1:slow flash 2：fast flash
volatile uint8_t ledCount = 0;   //0-2:LED OFF  3:LED ON 
const uint8_t ledCountValue = 3;
static boolean output = HIGH;

void setup() 
{
  /*  timer  */
  MsTimer::set(83, ledToggle);
  MsTimer::start();
  
  /*  Serial monitor  */
  Serial.begin(9600);
  
  /*  LED  */
  pinMode(LED, OUTPUT);                                 
  digitalWrite(LED, HIGH); //not get paired：LED on
  
  /*  BMP73T104  */
  myStepper1.begin(STEP1,HALF_STEP);
  myStepper1.setStepperMaxSpeed(1200);
  myStepper1.setStepperAcceleration(800);
    
  /*  BMC23M0x1  */                
  BMC23.begin(RF_433MHz);          //Set the Baud rate of the UART to 19200    
  BMC23.setPairMode();    //Enter the pairing mode, and automatically enter the RX mode after successful pairing */                                                        
  while(BMC23.getRFStatus()& 0x04)   //Determine whether it is in pairing
  {
    ledFlag = 1;   //pairing：LED flash
  }
  if((BMC23.getRFStatus() & 0x20) == 0x20)//pairing success
  {
    ledFlag = 0;
    digitalWrite(LED, LOW); //pairing success：LED off
  }
  else
  {
    ledFlag = 0;
    digitalWrite(LED, HIGH); //pairing failure：LED on
  }
}

void loop() 
{
 if(!BMC23.getStatus())//Determine whether the STATUS pin is low
 { 
   receiveData_Temp = 0;
   if(BMC23.getRFStatus()& 0x20) //Determine whether there is data to be read
   {
      receiveData_Temp = BMC23.readRFData();  //Read the received data
      if(receiveData != receiveData_Temp)//a different touch key is touched
      {
        receiveData = receiveData_Temp;
        switch(receiveData)
        {
           case 0x01:
                motorRun();
                break;
           case 0x02:
                motorStop();
                break;
           case 0x04:
                ledON();
                break;
           case 0x08:
                ledOFF();
                break;
           default:
                break;
         }
         
      }
   } 
 }
 delay(10); 
}
void motorRun()
{
  myStepper1.stepperRun(CCW,600);
}
void motorStop()
{
  myStepper1.stepperStop();
}
void ledToggle()
{
  if(ledFlag == 0)//OFF
  {
    
  }
  else if(ledFlag == 1)//slow flash
  {
    if(ledCount == ledCountValue)
    {
       digitalWrite(LED, output);
       output = !output;
    }
    ledCount++;
    if(ledCount == (ledCountValue+1))
    {
      ledCount = 0;
    }
  }
  else//fast flash
  {
       digitalWrite(LED, output);
       output = !output;
  }
}
void ledON()
{
  output = HIGH;
  ledFlag = 1;

}
void ledOFF()
{
  output = LOW;
  digitalWrite(LED, output);
  ledFlag = 0;
}
